/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import com.ice.tar.TarEntry;
import com.ice.tar.TarGzOutputStream;
import com.ice.tar.TarInputStream;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import vlcskineditor.Config;
import vlcskineditor.CustomFileFilter;
import vlcskineditor.FrameUpdater;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.ItemTransferHandler;
import vlcskineditor.Language;
import vlcskineditor.Layout;
import vlcskineditor.PreviewWindow;
import vlcskineditor.ProgressWindow;
import vlcskineditor.Resource;
import vlcskineditor.Skin;
import vlcskineditor.TreeRenderer;
import vlcskineditor.Window;
import vlcskineditor.history.History;
import vlcskineditor.history.ItemDeletionEvent;
import vlcskineditor.history.LayoutDeletionEvent;
import vlcskineditor.history.ResourceDeletionEvent;
import vlcskineditor.history.SubBitmapDeletionEvent;
import vlcskineditor.history.WindowDeletionEvent;
import vlcskineditor.items.Anchor;
import vlcskineditor.items.Button;
import vlcskineditor.items.Checkbox;
import vlcskineditor.items.Group;
import vlcskineditor.items.Image;
import vlcskineditor.items.Panel;
import vlcskineditor.items.Playtree;
import vlcskineditor.items.RadialSlider;
import vlcskineditor.items.Slider;
import vlcskineditor.items.SliderBackground;
import vlcskineditor.items.Text;
import vlcskineditor.items.Video;
import vlcskineditor.resources.Bitmap;
import vlcskineditor.resources.Font;
import vlcskineditor.resources.SubBitmap;

public class Main
extends JFrame
implements ActionListener,
TreeSelectionListener,
WindowListener,
MouseListener {
    private static final long serialVersionUID = 801L;
    private final String updateURL_s = "http://www.videolan.org/vlc/skineditor_update.php";
    public static final String VERSION = "0.8.1";
    private String vlc_dir = "";
    private String vlc_skins_dir = "";
    private JMenuBar mbar;
    private JMenu m_file;
    private JMenu m_edit;
    private JMenu m_help;
    private JMenuItem m_file_new;
    private JMenuItem m_file_open;
    private JMenuItem m_file_save;
    private JMenuItem m_file_test;
    private JMenuItem m_file_vlt;
    private JMenuItem m_file_png;
    private JMenuItem m_file_quit;
    private JMenuItem m_edit_undo;
    private JMenuItem m_edit_redo;
    private JMenuItem m_edit_theme;
    private JMenuItem m_edit_vars;
    private JMenuItem m_edit_prefs;
    private JMenuItem m_edit_up;
    private JMenuItem m_edit_down;
    private JMenuItem m_edit_right;
    private JMenuItem m_edit_left;
    private JMenuItem m_help_doc;
    private JMenuItem m_help_about;
    private JDesktopPane jdesk;
    private JInternalFrame resources;
    private JInternalFrame windows;
    private JInternalFrame items;
    protected JTree res_tree;
    protected JTree win_tree;
    protected JTree items_tree;
    protected DefaultTreeModel res_tree_model;
    protected DefaultTreeModel win_tree_model;
    protected DefaultTreeModel items_tree_model;
    private DefaultTreeCellRenderer tree_renderer = new TreeRenderer();
    private JButton res_add_bitmap;
    private JButton res_add_font;
    private JButton res_duplicate;
    private JButton res_edit;
    private JButton res_del;
    private JPopupMenu res_add_bitmap_pu;
    private JMenuItem res_add_bitmap_pu_b;
    private JMenuItem res_add_bitmap_pu_s;
    private JButton win_add_window;
    private JButton win_add_layout;
    private JButton win_layout_up;
    private JButton win_layout_down;
    private JButton win_duplicate;
    private JButton win_edit;
    private JButton win_del;
    private JButton items_add;
    private JButton items_up;
    private JButton items_down;
    private JButton items_duplicate;
    private JButton items_edit;
    private JButton items_del;
    private JPopupMenu items_add_pu;
    private JMenu items_add_pu_tp;
    private JMenuItem items_add_pu_tp_anchor;
    private JMenuItem items_add_pu_tp_button;
    private JMenuItem items_add_pu_tp_checkbox;
    private JMenuItem items_add_pu_tp_image;
    private JMenuItem items_add_pu_tp_panel;
    private JMenuItem items_add_pu_tp_playtree;
    private JMenuItem items_add_pu_tp_slider;
    private JMenuItem items_add_pu_tp_text;
    private JMenuItem items_add_pu_tp_video;
    private JMenuItem items_add_pu_anchor;
    private JMenuItem items_add_pu_button;
    private JMenuItem items_add_pu_checkbox;
    private JMenuItem items_add_pu_image;
    private JMenuItem items_add_pu_panel;
    private JMenuItem items_add_pu_playtree;
    private JMenuItem items_add_pu_slider;
    private JMenuItem items_add_pu_text;
    private JMenuItem items_add_pu_video;
    Skin s;
    public static ImageIcon add_bitmap_icon = Main.createIcon("icons/add_bitmap.png");
    public static ImageIcon add_font_icon = Main.createIcon("icons/add_font.png");
    public static ImageIcon copy_icon = Main.createIcon("icons/copy.png");
    public static ImageIcon edit_icon = Main.createIcon("icons/edit.png");
    public static ImageIcon edit_undo_icon = Main.createIcon("icons/edit-undo.png");
    public static ImageIcon edit_redo_icon = Main.createIcon("icons/edit-redo.png");
    public static ImageIcon editor_icon = Main.createIcon("icons/editor.png");
    public static ImageIcon delete_icon = Main.createIcon("icons/delete.png");
    public static ImageIcon add_window_icon = Main.createIcon("icons/add_window.png");
    public static ImageIcon add_layout_icon = Main.createIcon("icons/add_layout.png");
    public static ImageIcon add_icon = Main.createIcon("icons/add.png");
    public static ImageIcon up_icon = Main.createIcon("icons/move_up.png");
    public static ImageIcon down_icon = Main.createIcon("icons/move_down.png");
    public static ImageIcon help_icon = Main.createIcon("icons/help.png");
    public static ImageIcon icon = Main.createIcon("icons/icon.png");
    public static ImageIcon open_icon = Main.createIcon("icons/open.png");
    public static ImageIcon save_icon = Main.createIcon("icons/save.png");
    public static ImageIcon vlc_icon = Main.createIcon("icons/vlc16x16.png");
    public static ImageIcon vlt_icon = Main.createIcon("icons/vlt.png");
    public static ImageIcon new_icon = Main.createIcon("icons/new.png");
    public static ImageIcon exit_icon = Main.createIcon("icons/exit.png");
    public static ImageIcon resources_icon = Main.createIcon("icons/resources.png");
    public static ImageIcon windows_icon = Main.createIcon("icons/windows.png");
    public static ImageIcon items_icon = Main.createIcon("icons/items.png");
    public static ImageIcon preview_icon = Main.createIcon("icons/preview.png");
    protected String selected_resource;
    protected String selected_in_windows;
    protected String selected_window;
    protected String selected_layout;
    protected String selected_item;
    private JFileChooser base_fc;
    private JFileChooser bitmap_adder;
    private JFileChooser font_adder;
    private JFileChooser vlt_fc;
    protected PreviewWindow pvwin;
    public boolean saved = false;
    boolean opening = false;
    boolean opened = false;
    public History hist;
    public static final int TEXTFIELD_WIDTH = 200;

    public Main(String[] stringArray) {
        this.setTitle("VLC Skin Editor 0.8.1");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.setSize(800, 700);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("icons/icon16.png")));
        this.mbar = new JMenuBar();
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.m_file = new JMenu(Language.get("MENU_FILE"));
        this.m_file.setMnemonic(Language.get("MENU_FILE_MN").charAt(0));
        this.m_file_new = new JMenuItem(Language.get("MENU_FILE_NEW"));
        this.m_file_new.setIcon(new_icon);
        this.m_file_new.setMnemonic(Language.get("MENU_FILE_NEW_MN").charAt(0));
        this.m_file_new.setAccelerator(KeyStroke.getKeyStroke(78, n));
        this.m_file_new.addActionListener(this);
        this.m_file_open = new JMenuItem(Language.get("MENU_FILE_OPEN"));
        this.m_file_open.setIcon(open_icon);
        this.m_file_open.setMnemonic(Language.get("MENU_FILE_OPEN_MN").charAt(0));
        this.m_file_open.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.m_file_open.addActionListener(this);
        this.m_file_save = new JMenuItem(Language.get("MENU_FILE_SAVE"));
        this.m_file_save.setIcon(save_icon);
        this.m_file_save.setMnemonic(Language.get("MENU_FILE_SAVE_MN").charAt(0));
        this.m_file_save.setAccelerator(KeyStroke.getKeyStroke(83, n));
        this.m_file_save.addActionListener(this);
        this.m_file_test = new JMenuItem(Language.get("MENU_FILE_TEST"));
        this.m_file_test.setIcon(vlc_icon);
        this.m_file_test.setMnemonic(Language.get("MENU_FILE_TEST_MN").charAt(0));
        this.m_file_test.setAccelerator(KeyStroke.getKeyStroke(84, n + 64));
        this.m_file_test.addActionListener(this);
        this.m_file_vlt = new JMenuItem(Language.get("MENU_FILE_VLT"));
        this.m_file_vlt.setIcon(vlt_icon);
        this.m_file_vlt.setMnemonic(Language.get("MENU_FILE_VLT_MN").charAt(0));
        this.m_file_vlt.setAccelerator(KeyStroke.getKeyStroke(86, n + 64));
        this.m_file_vlt.addActionListener(this);
        this.m_file_png = new JMenuItem(Language.get("MENU_FILE_PNG"));
        this.m_file_png.setMnemonic(Language.get("MENU_FILE_PNG_MN").charAt(0));
        this.m_file_png.addActionListener(this);
        this.m_file_png.setEnabled(false);
        if (System.getProperty("os.name").indexOf("Mac") == -1) {
            this.m_file_quit = new JMenuItem(Language.get("MENU_FILE_EXIT"));
            this.m_file_quit.setIcon(exit_icon);
            this.m_file_quit.setMnemonic(Language.get("MENU_FILE_EXIT_MN").charAt(0));
            this.m_file_quit.setAccelerator(KeyStroke.getKeyStroke("alt F4"));
            this.m_file_quit.addActionListener(this);
        }
        this.m_file.add(this.m_file_new);
        this.m_file.addSeparator();
        this.m_file.add(this.m_file_open);
        this.m_file.add(this.m_file_save);
        this.m_file.addSeparator();
        this.m_file.add(this.m_file_test);
        this.m_file.add(this.m_file_vlt);
        this.m_file.add(this.m_file_png);
        this.m_file.addSeparator();
        if (System.getProperty("os.name").indexOf("Mac") == -1) {
            this.m_file.add(this.m_file_quit);
        }
        this.m_edit = new JMenu(Language.get("MENU_EDIT"));
        this.m_edit.setMnemonic(Language.get("MENU_EDIT_MN").charAt(0));
        this.m_edit_undo = new JMenuItem(Language.get("MENU_EDIT_UNDO"));
        this.m_edit_undo.setIcon(edit_undo_icon);
        this.m_edit_undo.setMnemonic(Language.get("MENU_EDIT_UNDO_MN").charAt(0));
        this.m_edit_undo.setAccelerator(KeyStroke.getKeyStroke(90, n));
        this.m_edit_undo.addActionListener(this);
        this.m_edit_redo = new JMenuItem(Language.get("MENU_EDIT_REDO"));
        this.m_edit_redo.setIcon(edit_redo_icon);
        this.m_edit_redo.setMnemonic(Language.get("MENU_EDIT_REDO_MN").charAt(0));
        this.m_edit_redo.setAccelerator(KeyStroke.getKeyStroke(89, n));
        this.m_edit_redo.addActionListener(this);
        this.m_edit_theme = new JMenuItem(Language.get("MENU_EDIT_THEME"));
        this.m_edit_theme.setIcon(edit_icon);
        this.m_edit_theme.setMnemonic(Language.get("MENU_EDIT_THEME_MN").charAt(0));
        this.m_edit_theme.setAccelerator(KeyStroke.getKeyStroke(73, n));
        this.m_edit_theme.addActionListener(this);
        this.m_edit_vars = new JMenuItem(Language.get("MENU_EDIT_VARS"));
        this.m_edit_vars.setMnemonic(Language.get("MENU_EDIT_VARS_MN").charAt(0));
        this.m_edit_vars.setAccelerator(KeyStroke.getKeyStroke(71, n));
        this.m_edit_vars.addActionListener(this);
        this.m_edit_prefs = new JMenuItem(Language.get("MENU_EDIT_PREFS"));
        this.m_edit_prefs.setIcon(editor_icon);
        this.m_edit_prefs.setMnemonic(Language.get("MENU_EDIT_PREFS_MN").charAt(0));
        this.m_edit_prefs.addActionListener(this);
        this.m_edit_up = new JMenuItem(Language.get("MENU_EDIT_UP"));
        this.m_edit_up.setAccelerator(KeyStroke.getKeyStroke(38, n));
        this.m_edit_up.addActionListener(this);
        this.m_edit_down = new JMenuItem(Language.get("MENU_EDIT_DOWN"));
        this.m_edit_down.setAccelerator(KeyStroke.getKeyStroke(40, n));
        this.m_edit_down.addActionListener(this);
        this.m_edit_left = new JMenuItem(Language.get("MENU_EDIT_LEFT"));
        this.m_edit_left.setAccelerator(KeyStroke.getKeyStroke(37, n));
        this.m_edit_left.addActionListener(this);
        this.m_edit_right = new JMenuItem(Language.get("MENU_EDIT_RIGHT"));
        this.m_edit_right.setAccelerator(KeyStroke.getKeyStroke(39, n));
        this.m_edit_right.addActionListener(this);
        this.m_edit.add(this.m_edit_undo);
        this.m_edit.add(this.m_edit_redo);
        this.m_edit.addSeparator();
        this.m_edit.add(this.m_edit_theme);
        this.m_edit.addSeparator();
        this.m_edit.add(this.m_edit_vars);
        this.m_edit.add(this.m_edit_prefs);
        this.m_edit.addSeparator();
        this.m_edit.add(this.m_edit_up);
        this.m_edit.add(this.m_edit_down);
        this.m_edit.add(this.m_edit_left);
        this.m_edit.add(this.m_edit_right);
        this.m_help = new JMenu(Language.get("MENU_HELP"));
        this.m_help.setMnemonic(Language.get("MENU_HELP_MN").charAt(0));
        this.m_help_doc = new JMenuItem(Language.get("MENU_HELP_DOC"));
        this.m_help_doc.setIcon(help_icon);
        this.m_help_doc.setMnemonic(Language.get("MENU_HELP_DOC_MN").charAt(0));
        this.m_help_doc.addActionListener(this);
        this.m_help_doc.setAccelerator(KeyStroke.getKeyStroke("F1"));
        this.m_help_about = new JMenuItem(Language.get("MENU_HELP_ABOUT"));
        this.m_help_about.setMnemonic(Language.get("MENU_HELP_ABOUT_MN").charAt(0));
        this.m_help_about.addActionListener(this);
        this.m_help.add(this.m_help_doc);
        this.m_help.add(this.m_help_about);
        this.mbar.add(this.m_file);
        this.mbar.add(this.m_edit);
        this.mbar.add(this.m_help);
        this.setJMenuBar(this.mbar);
        this.jdesk = new JDesktopPane();
        this.s = new Skin(this);
        this.resources = new JInternalFrame(Language.get("WIN_RES_TITLE"), true, false);
        this.resources.setFrameIcon(resources_icon);
        this.resources.setMinimumSize(new Dimension(190, 200));
        SpringLayout springLayout = new SpringLayout();
        this.resources.setLayout(springLayout);
        this.res_tree_model = new DefaultTreeModel(this.s.getResourcesTree());
        this.res_tree = new JTree(this.res_tree_model);
        ToolTipManager.sharedInstance().registerComponent(this.res_tree);
        this.res_tree.setCellRenderer(this.tree_renderer);
        this.res_tree.setRootVisible(false);
        this.res_tree.setShowsRootHandles(true);
        this.res_tree.getSelectionModel().setSelectionMode(1);
        this.res_tree.addTreeSelectionListener(this);
        this.res_tree.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.res_tree);
        this.resources.add(jScrollPane);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(1));
        this.res_add_bitmap = new JButton("", add_bitmap_icon);
        this.res_add_bitmap.setToolTipText(Language.get("WIN_RES_ADD_BMP"));
        this.res_add_bitmap.setMaximumSize(new Dimension(24, 24));
        this.res_add_bitmap.setPreferredSize(new Dimension(24, 24));
        this.res_add_bitmap.addActionListener(this);
        this.res_add_font = new JButton("", add_font_icon);
        this.res_add_font.setToolTipText(Language.get("WIN_RES_ADD_FONT"));
        this.res_add_font.setMaximumSize(new Dimension(24, 24));
        this.res_add_font.setPreferredSize(new Dimension(24, 24));
        this.res_add_font.addActionListener(this);
        this.res_duplicate = new JButton("", copy_icon);
        this.res_duplicate.setToolTipText(Language.get("WIN_RES_COPY"));
        this.res_duplicate.setPreferredSize(new Dimension(24, 24));
        this.res_duplicate.addActionListener(this);
        this.res_edit = new JButton("", edit_icon);
        this.res_edit.setToolTipText(Language.get("WIN_RES_EDIT"));
        this.res_edit.setMaximumSize(new Dimension(24, 24));
        this.res_edit.setPreferredSize(new Dimension(24, 24));
        this.res_edit.addActionListener(this);
        this.res_del = new JButton("", delete_icon);
        this.res_del.setToolTipText(Language.get("WIN_RES_DELETE"));
        this.res_del.setMaximumSize(new Dimension(24, 24));
        this.res_del.setPreferredSize(new Dimension(24, 24));
        this.res_del.addActionListener(this);
        this.resources.add(this.res_add_bitmap);
        this.resources.add(this.res_add_font);
        this.resources.add(this.res_duplicate);
        this.resources.add(this.res_edit);
        this.resources.add(this.res_del);
        springLayout.putConstraint("West", (Component)jScrollPane, 5, "West", (Component)this.resources.getContentPane());
        springLayout.putConstraint("North", (Component)jScrollPane, 5, "North", (Component)this.resources.getContentPane());
        springLayout.putConstraint("North", (Component)this.res_add_bitmap, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_add_font, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_duplicate, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_edit, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_del, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_add_bitmap, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_add_font, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_edit, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.res_del, 5, "South", (Component)jScrollPane);
        springLayout.putConstraint("West", (Component)this.res_add_bitmap, 5, "West", (Component)this.resources.getContentPane());
        springLayout.putConstraint("West", (Component)this.res_add_font, 5, "East", (Component)this.res_add_bitmap);
        springLayout.putConstraint("West", (Component)this.res_duplicate, 5, "East", (Component)this.res_add_font);
        springLayout.putConstraint("West", (Component)this.res_edit, 5, "East", (Component)this.res_duplicate);
        springLayout.putConstraint("West", (Component)this.res_del, 5, "East", (Component)this.res_edit);
        springLayout.putConstraint("South", (Component)this.resources.getContentPane(), 34, "South", (Component)jScrollPane);
        springLayout.putConstraint("North", (Component)this.resources.getContentPane(), 5, "North", (Component)jScrollPane);
        springLayout.putConstraint("East", (Component)this.resources.getContentPane(), 5, "East", (Component)jScrollPane);
        this.resources.pack();
        this.resources.setSize(Config.getInt("win.res.width"), Config.getInt("win.res.height"));
        this.resources.setVisible(true);
        this.windows = new JInternalFrame(Language.get("WIN_WIN_TITLE"), true, false);
        this.windows.setFrameIcon(windows_icon);
        this.windows.setMinimumSize(new Dimension(190, 150));
        SpringLayout springLayout2 = new SpringLayout();
        this.windows.setLayout(springLayout2);
        this.win_tree_model = new DefaultTreeModel(this.s.getWindowsTree());
        this.win_tree = new JTree(this.win_tree_model);
        ToolTipManager.sharedInstance().registerComponent(this.win_tree);
        this.win_tree.setCellRenderer(this.tree_renderer);
        this.win_tree.setRootVisible(false);
        this.win_tree.setShowsRootHandles(true);
        this.win_tree.getSelectionModel().setSelectionMode(1);
        this.win_tree.addTreeSelectionListener(this);
        this.win_tree.addMouseListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.win_tree);
        this.windows.add(jScrollPane2);
        jScrollPane2.setBorder(BorderFactory.createEtchedBorder(1));
        this.win_add_window = new JButton("", add_window_icon);
        this.win_add_window.setToolTipText(Language.get("WIN_WIN_ADD"));
        this.win_add_window.setMaximumSize(new Dimension(24, 24));
        this.win_add_window.setPreferredSize(new Dimension(24, 24));
        this.win_add_window.addActionListener(this);
        this.win_add_layout = new JButton("", add_layout_icon);
        this.win_add_layout.setToolTipText(Language.get("WIN_WIN_ADD_LAY"));
        this.win_add_layout.setMaximumSize(new Dimension(24, 24));
        this.win_add_layout.setPreferredSize(new Dimension(24, 24));
        this.win_add_layout.addActionListener(this);
        this.win_layout_up = new JButton("", up_icon);
        this.win_layout_up.setToolTipText(Language.get("WIN_WIN_MOVE_UP"));
        this.win_layout_up.setMaximumSize(new Dimension(24, 12));
        this.win_layout_up.setPreferredSize(new Dimension(24, 12));
        this.win_layout_up.addActionListener(this);
        this.win_layout_up.setEnabled(false);
        this.win_layout_down = new JButton("", down_icon);
        this.win_layout_down.setToolTipText(Language.get("WIN_WIN_MOVE_DOWN"));
        this.win_layout_down.setMaximumSize(new Dimension(24, 12));
        this.win_layout_down.setPreferredSize(new Dimension(24, 12));
        this.win_layout_down.addActionListener(this);
        this.win_layout_down.setEnabled(false);
        this.win_duplicate = new JButton("", copy_icon);
        this.win_duplicate.setToolTipText(Language.get("WIN_WIN_COPY"));
        this.win_duplicate.setMaximumSize(new Dimension(24, 24));
        this.win_duplicate.setPreferredSize(new Dimension(24, 24));
        this.win_duplicate.addActionListener(this);
        this.win_edit = new JButton("", edit_icon);
        this.win_edit.setToolTipText(Language.get("WIN_WIN_EDIT"));
        this.win_edit.setMaximumSize(new Dimension(24, 24));
        this.win_edit.setPreferredSize(new Dimension(24, 24));
        this.win_edit.addActionListener(this);
        this.win_del = new JButton("", delete_icon);
        this.win_del.setToolTipText(Language.get("WIN_WIN_DELETE"));
        this.win_del.setMaximumSize(new Dimension(24, 24));
        this.win_del.setPreferredSize(new Dimension(24, 24));
        this.win_del.addActionListener(this);
        this.windows.add(this.win_add_window);
        this.windows.add(this.win_add_layout);
        this.windows.add(this.win_duplicate);
        this.windows.add(this.win_edit);
        this.windows.add(this.win_layout_up);
        this.windows.add(this.win_layout_down);
        this.windows.add(this.win_del);
        springLayout2.putConstraint("West", (Component)jScrollPane2, 5, "West", (Component)this.windows.getContentPane());
        springLayout2.putConstraint("North", (Component)jScrollPane2, 5, "North", (Component)this.windows.getContentPane());
        springLayout2.putConstraint("North", (Component)this.win_add_window, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.win_add_layout, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.win_layout_up, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.win_layout_down, 0, "South", (Component)this.win_layout_up);
        springLayout2.putConstraint("North", (Component)this.win_duplicate, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.win_edit, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.win_del, 5, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("West", (Component)this.win_add_window, 5, "West", (Component)this.windows.getContentPane());
        springLayout2.putConstraint("West", (Component)this.win_add_layout, 5, "East", (Component)this.win_add_window);
        springLayout2.putConstraint("West", (Component)this.win_layout_up, 5, "East", (Component)this.win_add_layout);
        springLayout2.putConstraint("West", (Component)this.win_layout_down, 5, "East", (Component)this.win_add_layout);
        springLayout2.putConstraint("West", (Component)this.win_duplicate, 5, "East", (Component)this.win_layout_up);
        springLayout2.putConstraint("West", (Component)this.win_edit, 5, "East", (Component)this.win_duplicate);
        springLayout2.putConstraint("West", (Component)this.win_del, 5, "East", (Component)this.win_edit);
        springLayout2.putConstraint("South", (Component)this.windows.getContentPane(), 34, "South", (Component)jScrollPane2);
        springLayout2.putConstraint("North", (Component)this.windows.getContentPane(), 5, "North", (Component)jScrollPane2);
        springLayout2.putConstraint("East", (Component)this.windows.getContentPane(), 5, "East", (Component)jScrollPane2);
        this.windows.pack();
        this.windows.setSize(Config.getInt("win.win.width"), Config.getInt("win.win.height"));
        this.windows.setVisible(true);
        this.items = new JInternalFrame(Language.get("WIN_ITEMS_TITLE"), true, false);
        this.items.setFrameIcon(items_icon);
        this.items.setMinimumSize(new Dimension(190, 150));
        SpringLayout springLayout3 = new SpringLayout();
        this.items.setLayout(springLayout3);
        this.items_tree_model = new DefaultTreeModel(this.s.getItemsTree());
        this.items_tree = new JTree(this.items_tree_model);
        ToolTipManager.sharedInstance().registerComponent(this.items_tree);
        this.items_tree.setCellRenderer(this.tree_renderer);
        this.items_tree.setRootVisible(false);
        this.items_tree.getSelectionModel().setSelectionMode(1);
        this.items_tree.addTreeSelectionListener(this);
        this.items_tree.setDragEnabled(true);
        this.items_tree.setDropMode(DropMode.ON_OR_INSERT);
        this.items_tree.setTransferHandler(new ItemTransferHandler(this.s));
        this.items_tree.setShowsRootHandles(true);
        this.items_tree.addMouseListener(this);
        JScrollPane jScrollPane3 = new JScrollPane(this.items_tree);
        this.items.add(jScrollPane3);
        jScrollPane3.setBorder(BorderFactory.createEtchedBorder(1));
        this.items_add = new JButton("", add_icon);
        this.items_add.setToolTipText(Language.get("WIN_ITEMS_ADD"));
        this.items_add.setMaximumSize(new Dimension(24, 24));
        this.items_add.setPreferredSize(new Dimension(24, 24));
        this.items_add.addActionListener(this);
        this.items_up = new JButton("", up_icon);
        this.items_up.setToolTipText(Language.get("WIN_ITEMS_MOVE_UP"));
        this.items_up.setMaximumSize(new Dimension(24, 12));
        this.items_up.setPreferredSize(new Dimension(24, 12));
        this.items_up.addActionListener(this);
        this.items_down = new JButton("", down_icon);
        this.items_down.setToolTipText(Language.get("WIN_ITEMS_MOVE_DOWN"));
        this.items_down.setMaximumSize(new Dimension(24, 12));
        this.items_down.setPreferredSize(new Dimension(24, 12));
        this.items_down.addActionListener(this);
        this.items_duplicate = new JButton("", copy_icon);
        this.items_duplicate.setToolTipText(Language.get("WIN_ITEMS_COPY"));
        this.items_duplicate.setMaximumSize(new Dimension(24, 24));
        this.items_duplicate.setPreferredSize(new Dimension(24, 24));
        this.items_duplicate.addActionListener(this);
        this.items_edit = new JButton("", edit_icon);
        this.items_edit.setToolTipText(Language.get("WIN_ITEMS_EDIT"));
        this.items_edit.setMaximumSize(new Dimension(24, 24));
        this.items_edit.setPreferredSize(new Dimension(24, 24));
        this.items_edit.addActionListener(this);
        this.items_del = new JButton("", delete_icon);
        this.items_del.setToolTipText(Language.get("WIN_ITEMS_DELETE"));
        this.items_del.setMaximumSize(new Dimension(24, 24));
        this.items_del.setPreferredSize(new Dimension(24, 24));
        this.items_del.addActionListener(this);
        this.items.add(this.items_add);
        this.items.add(this.items_up);
        this.items.add(this.items_down);
        this.items.add(this.items_duplicate);
        this.items.add(this.items_edit);
        this.items.add(this.items_del);
        springLayout3.putConstraint("West", (Component)jScrollPane3, 5, "West", (Component)this.items.getContentPane());
        springLayout3.putConstraint("North", (Component)jScrollPane3, 5, "North", (Component)this.items.getContentPane());
        springLayout3.putConstraint("North", (Component)this.items_add, 5, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("North", (Component)this.items_up, 5, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("North", (Component)this.items_down, 0, "South", (Component)this.items_up);
        springLayout3.putConstraint("North", (Component)this.items_duplicate, 5, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("North", (Component)this.items_edit, 5, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("North", (Component)this.items_del, 5, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("West", (Component)this.items_add, 5, "West", (Component)this.items.getContentPane());
        springLayout3.putConstraint("West", (Component)this.items_up, 5, "East", (Component)this.items_add);
        springLayout3.putConstraint("West", (Component)this.items_down, 5, "East", (Component)this.items_add);
        springLayout3.putConstraint("West", (Component)this.items_duplicate, 5, "East", (Component)this.items_up);
        springLayout3.putConstraint("West", (Component)this.items_edit, 5, "East", (Component)this.items_duplicate);
        springLayout3.putConstraint("West", (Component)this.items_del, 5, "East", (Component)this.items_edit);
        springLayout3.putConstraint("South", (Component)this.items.getContentPane(), 34, "South", (Component)jScrollPane3);
        springLayout3.putConstraint("North", (Component)this.items.getContentPane(), 5, "North", (Component)jScrollPane3);
        springLayout3.putConstraint("East", (Component)this.items.getContentPane(), 5, "East", (Component)jScrollPane3);
        this.items.pack();
        this.items.setSize(Config.getInt("win.items.width"), Config.getInt("win.items.height"));
        this.items.setVisible(true);
        this.pvwin = new PreviewWindow(this);
        this.jdesk.add(this.resources);
        this.jdesk.add(this.windows);
        this.jdesk.add(this.items);
        this.jdesk.add(this.pvwin.frame);
        this.resources.setLocation(Config.getInt("win.res.x"), Config.getInt("win.res.y"));
        this.windows.setLocation(Config.getInt("win.win.x"), Config.getInt("win.win.y"));
        this.items.setLocation(Config.getInt("win.items.x"), Config.getInt("win.items.y"));
        this.pvwin.frame.setLocation(250, 0);
        this.res_add_bitmap_pu = new JPopupMenu();
        this.res_add_bitmap_pu_b = new JMenuItem(Language.get("WIN_RES_PU_ADD_BMP"));
        this.res_add_bitmap_pu_b.addActionListener(this);
        this.res_add_bitmap_pu.add(this.res_add_bitmap_pu_b);
        this.res_add_bitmap_pu_s = new JMenuItem(Language.get("WIN_RES_PU_ADD_SBMP"));
        this.res_add_bitmap_pu_s.addActionListener(this);
        this.res_add_bitmap_pu.add(this.res_add_bitmap_pu_s);
        this.jdesk.add(this.res_add_bitmap_pu);
        this.items_add_pu = new JPopupMenu();
        this.items_add_pu_tp = new JMenu(Language.get("WIN_ITEMS_PU_PANEL_ADD"));
        this.items_add_pu_tp_anchor = new JMenuItem(Language.get("ANCHOR"));
        this.items_add_pu_tp_anchor.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_anchor);
        this.items_add_pu_tp_button = new JMenuItem(Language.get("BUTTON"));
        this.items_add_pu_tp_button.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_button);
        this.items_add_pu_tp_checkbox = new JMenuItem(Language.get("CHECKBOX"));
        this.items_add_pu_tp_checkbox.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_checkbox);
        this.items_add_pu_tp_image = new JMenuItem(Language.get("IMAGE"));
        this.items_add_pu_tp_image.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_image);
        this.items_add_pu_tp_panel = new JMenuItem(Language.get("PANEL"));
        this.items_add_pu_tp_panel.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_panel);
        this.items_add_pu_tp_playtree = new JMenuItem(Language.get("PLAYTREE"));
        this.items_add_pu_tp_playtree.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_playtree);
        this.items_add_pu_tp_slider = new JMenuItem(Language.get("SLIDER"));
        this.items_add_pu_tp_slider.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_slider);
        this.items_add_pu_tp_text = new JMenuItem(Language.get("TEXT"));
        this.items_add_pu_tp_text.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_text);
        this.items_add_pu_tp_video = new JMenuItem(Language.get("VIDEO"));
        this.items_add_pu_tp_video.addActionListener(this);
        this.items_add_pu_tp.add(this.items_add_pu_tp_video);
        this.items_add_pu.add(this.items_add_pu_tp);
        this.items_add_pu.addSeparator();
        this.items_add_pu_anchor = new JMenuItem(Language.get("ANCHOR"));
        this.items_add_pu_anchor.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_anchor);
        this.items_add_pu_button = new JMenuItem(Language.get("BUTTON"));
        this.items_add_pu_button.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_button);
        this.items_add_pu_checkbox = new JMenuItem(Language.get("CHECKBOX"));
        this.items_add_pu_checkbox.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_checkbox);
        this.items_add_pu_image = new JMenuItem(Language.get("IMAGE"));
        this.items_add_pu_image.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_image);
        this.items_add_pu_panel = new JMenuItem(Language.get("PANEL"));
        this.items_add_pu_panel.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_panel);
        this.items_add_pu_playtree = new JMenuItem(Language.get("PLAYTREE"));
        this.items_add_pu_playtree.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_playtree);
        this.items_add_pu_slider = new JMenuItem(Language.get("SLIDER"));
        this.items_add_pu_slider.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_slider);
        this.items_add_pu_text = new JMenuItem(Language.get("TEXT"));
        this.items_add_pu_text.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_text);
        this.items_add_pu_video = new JMenuItem(Language.get("VIDEO"));
        this.items_add_pu_video.addActionListener(this);
        this.items_add_pu.add(this.items_add_pu_video);
        this.jdesk.add(this.items_add_pu);
        this.jdesk.setMinimumSize(new Dimension(800, 600));
        this.add(this.jdesk);
        this.setSize(Config.getInt("win.main.width"), Config.getInt("win.main.height"));
        if (Config.get("win.main.x") == null) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(Config.getInt("win.main.x"), Config.getInt("win.main.y"));
        }
        if (Boolean.parseBoolean(Config.get("win.main.maximized"))) {
            this.setExtendedState(6);
        }
        this.setVisible(true);
        this.update();
        this.getVLCdirectory();
        if (stringArray.length > 0) {
            File file = new File(stringArray[0]);
            this.openFile(file);
        } else {
            this.showWelcomeDialog();
        }
    }

    private void getVLCdirectory() {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            try {
                RegistryKey registryKey = Registry.openSubkey(Registry.HKEY_LOCAL_MACHINE, "Software\\VideoLAN\\VLC", 1);
                String string = registryKey.getStringValue("InstallDir");
                this.vlc_dir = string + File.separator;
                this.vlc_skins_dir = this.vlc_dir + "skins\\";
            }
            catch (Exception exception) {
                System.err.println("Could not read VLC installation directory from Registry. VLC might not be properly installed.");
                exception.printStackTrace();
            }
        } else if (System.getProperty("os.name").indexOf("Linux") != -1) {
            this.vlc_skins_dir = "~/.local/share/vlc/skins2/";
        }
        if (this.base_fc == null) {
            this.base_fc = new JFileChooser();
        }
        if (Config.get("open.folder") == null) {
            this.base_fc.setCurrentDirectory(new File(this.vlc_skins_dir));
        } else {
            this.base_fc.setCurrentDirectory(new File(Config.get("open.folder")));
        }
    }

    public void showWelcomeDialog() {
        Object[] objectArray = new Object[]{Language.get("WELCOME_NEW"), Language.get("WELCOME_OPEN"), Language.get("WELCOME_QUIT")};
        int n = JOptionPane.showOptionDialog(this, Language.get("WELCOME_MSG"), Language.get("WELCOME_TITLE"), 1, 3, null, objectArray, objectArray[1]);
        if (n == 0) {
            this.createNew();
        } else if (n == 1) {
            this.openFile();
        } else {
            this.saved = true;
            this.exit();
        }
    }

    private void openFile() {
        this.opening = true;
        String[] stringArray = new String[]{"xml", "vlt"};
        if (System.getProperty("os.name").indexOf("Mac") == -1) {
            this.base_fc.setFileFilter(new CustomFileFilter(this.base_fc, stringArray, "*.xml (VLC XML-Skin), *.vlt (VLC Theme)", false, this.vlc_dir));
            int n = this.base_fc.showOpenDialog(this);
            if (n == 0) {
                this.openFile(this.base_fc.getSelectedFile());
                this.opening = false;
            } else {
                this.opening = false;
                if (!this.opened) {
                    this.showWelcomeDialog();
                }
            }
        } else {
            FileDialog fileDialog = new FileDialog(this);
            fileDialog.setMode(0);
            fileDialog.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.toUpperCase().endsWith(".XML");
                }
            });
            fileDialog.setVisible(true);
            String string = fileDialog.getFile();
            if (string != null) {
                this.openFile(new File(fileDialog.getDirectory(), fileDialog.getFile()));
                this.opening = false;
            } else {
                this.opening = false;
                if (!this.opened) {
                    this.showWelcomeDialog();
                }
            }
        }
    }

    private void openFile(File object) {
        if (!((File)object).exists()) {
            JOptionPane.showMessageDialog(this, Language.get("ERROR_FILENEXIST_MSG").replaceAll("%f", ((File)object).getName()), Language.get("ERROR_FILENEXIST_TITLE"), 0);
            if (!this.opened) {
                this.showWelcomeDialog();
            }
            return;
        }
        this.opening = true;
        if (this.pvwin != null) {
            this.pvwin.clearLayout();
        }
        ProgressWindow progressWindow = new ProgressWindow(this, "");
        if (((File)object).toString().toLowerCase().endsWith(".vlt")) {
            int n;
            BufferedOutputStream bufferedOutputStream;
            FileOutputStream fileOutputStream;
            BufferedInputStream bufferedInputStream;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Closeable closeable;
            String string = ((File)object).getName().replaceAll(".vlt", "");
            Object[] objectArray = new Object[]{Language.get("VLT_EX_YES"), Language.get("VLT_EX_NO")};
            int n2 = JOptionPane.showOptionDialog(this, Language.get("VLT_EX_MSG").replaceAll("%f", string + "_unpacked"), Language.get("VLT_EX_TITLE"), 1, 3, null, objectArray, objectArray[1]);
            if (n2 != 0) {
                this.showWelcomeDialog();
            }
            File file = new File(((File)object).getParent(), string + "_unpacked");
            file.mkdirs();
            boolean bl = false;
            progressWindow.setText(Language.get("VLT_EX_PROGRESS"));
            progressWindow.setVisible(true);
            try {
                closeable = new ZipFile((File)object);
                object5 = ((ZipFile)closeable).entries();
                while (object5.hasMoreElements()) {
                    object4 = object5.nextElement();
                    object3 = new File(file, ((ZipEntry)object4).getName());
                    if (((ZipEntry)object4).getName().endsWith("theme.xml")) {
                        object = object3;
                    }
                    if (((ZipEntry)object4).isDirectory()) {
                        ((File)object3).mkdirs();
                        continue;
                    }
                    object2 = ((ZipFile)closeable).getInputStream((ZipEntry)object4);
                    bufferedInputStream = new BufferedInputStream((InputStream)object2);
                    ((File)object3).getParentFile().mkdirs();
                    fileOutputStream = new FileOutputStream((File)object3);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    n = 0;
                    while ((n = bufferedInputStream.read()) != -1) {
                        bufferedOutputStream.write((byte)n);
                    }
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    bufferedInputStream.close();
                    ((InputStream)object2).close();
                }
                bl = true;
            }
            catch (IOException iOException) {
                System.out.println("VLT file is not a valid ZIP file. Trying tar.gz now...");
            }
            if (!bl) {
                try {
                    closeable = new FileInputStream((File)object);
                    object5 = new GZIPInputStream((InputStream)closeable);
                    object4 = new TarInputStream((InputStream)object5);
                    object3 = null;
                    while ((object3 = ((TarInputStream)object4).getNextEntry()) != null) {
                        object2 = new File(file, ((TarEntry)object3).getName());
                        if (((TarEntry)object3).getName().endsWith("theme.xml")) {
                            object = object2;
                        }
                        if (((TarEntry)object3).isDirectory()) {
                            ((File)object2).mkdirs();
                            continue;
                        }
                        bufferedInputStream = new BufferedInputStream((InputStream)object4);
                        ((File)object2).getParentFile().mkdirs();
                        fileOutputStream = new FileOutputStream((File)object2);
                        bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        n = 0;
                        while ((n = bufferedInputStream.read()) != -1) {
                            bufferedOutputStream.write((byte)n);
                        }
                        bufferedOutputStream.close();
                        fileOutputStream.close();
                    }
                    ((TarInputStream)object4).close();
                    ((GZIPInputStream)object5).close();
                    ((FileInputStream)closeable).close();
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (!bl) {
                progressWindow.setVisible(false);
                JOptionPane.showMessageDialog(this, Language.get("ERROR_VLT_UNPACK_MSG"), Language.get("ERROR_VLT_UNPACK_TITLE"), 0);
                this.opening = false;
                return;
            }
            if (object == this.base_fc.getSelectedFile()) {
                progressWindow.setVisible(false);
                JOptionPane.showMessageDialog(this, Language.get("ERROR_VLT_NOTHEME_MSG"), Language.get("ERROR_VLT_NOTHEME_TITLE"), 0);
                this.opening = false;
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        progressWindow.setText(Language.get("XML_PARSING_PROGRESS"));
        progressWindow.setVisible(true);
        this.setTitle(((File)object).toString() + " - VLC Skin Editor " + VERSION);
        this.m_file_png.setEnabled(false);
        this.s.open((File)object);
        this.selected_resource = null;
        this.selected_in_windows = null;
        this.selected_window = null;
        this.selected_item = null;
        this.saved = true;
        this.opening = false;
        this.opened = true;
        progressWindow.setVisible(false);
        progressWindow.dispose();
        this.hist = new History(this);
        this.s.gvars.sendUpdate();
    }

    private void createNew() {
        this.base_fc.setFileFilter(new CustomFileFilter(this.base_fc, "xml", "*.xml (VLC XML-Skin Files)", false, this.vlc_dir));
        int n = this.base_fc.showSaveDialog(this);
        if (n != 0) {
            if (!this.opened) {
                this.showWelcomeDialog();
            }
        } else {
            File file = this.base_fc.getSelectedFile();
            if (!file.getPath().toLowerCase().endsWith(".xml")) {
                file = new File(file.getPath() + ".xml");
            }
            this.setTitle(file.getPath() + " - VLC Skin Editor " + VERSION);
            this.s.createNew(file);
            this.selected_resource = null;
            this.selected_in_windows = null;
            this.selected_window = null;
            this.selected_item = null;
            this.saved = false;
            this.opened = true;
            this.hist = new History(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.m_file_new)) {
            this.createNew();
        } else if (actionEvent.getSource().equals(this.m_file_open)) {
            this.openFile();
        } else if (actionEvent.getSource().equals(this.m_file_save)) {
            this.s.save();
            this.saved = true;
        } else if (actionEvent.getSource().equals(this.m_file_test)) {
            this.s.save();
            this.saved = true;
            String[] stringArray = new String[]{this.vlc_dir + "vlc", "-I", "skins2", "--skins2-last=" + this.s.skinfile.toString(), "--skins2-systray"};
            try {
                Runtime.getRuntime().exec(stringArray);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, Language.get("ERROR_VLC_LAUNCH_MSG"), Language.get("ERROR_VLC_LAUNCH_ERROR"), 0);
            }
        } else if (actionEvent.getSource().equals(this.m_file_vlt)) {
            if (this.vlt_fc == null) {
                this.vlt_fc = new JFileChooser();
                this.vlt_fc.setCurrentDirectory(new File(this.vlc_skins_dir));
                this.vlt_fc.setFileFilter(new CustomFileFilter(this.vlt_fc, "vlt", ".vlt  (VLC Theme)", false, ""));
                this.vlt_fc.setAcceptAllFileFilterUsed(false);
            }
            int n = this.vlt_fc.showSaveDialog(this);
            File file = null;
            if (n == 0) {
                file = this.vlt_fc.getSelectedFile();
                if (!file.getPath().toLowerCase().endsWith(".vlt")) {
                    file = new File(file.getPath() + ".vlt");
                }
            } else {
                return;
            }
            ProgressWindow progressWindow = new ProgressWindow(this, "");
            progressWindow.setText(Language.get("VLT_PROGRESS"));
            progressWindow.setVisible(true);
            try {
                int n2;
                TarGzOutputStream tarGzOutputStream = new TarGzOutputStream(new FileOutputStream(file));
                TarEntry tarEntry = new TarEntry(this.s.skinfile);
                tarEntry.setName("theme.xml");
                tarGzOutputStream.putNextEntry(tarEntry);
                FileInputStream fileInputStream = new FileInputStream(this.s.skinfile);
                while ((n2 = fileInputStream.read()) != -1) {
                    tarGzOutputStream.write(n2);
                }
                fileInputStream.close();
                tarGzOutputStream.closeEntry();
                LinkedList<String> linkedList = new LinkedList<String>();
                for (int i = 0; i < this.s.resources.size(); ++i) {
                    Object object;
                    String string;
                    Resource resource;
                    if (this.s.resources.get(i).getClass().equals(Bitmap.class)) {
                        try {
                            int n3;
                            Object object2;
                            resource = (Bitmap)this.s.resources.get(i);
                            string = this.s.skinfolder + resource.file;
                            if (linkedList.contains(string)) continue;
                            object = new File(string);
                            if (!((File)object).exists()) {
                                if (System.getProperty("os.name").indexOf("Vista") != -1) {
                                    object2 = System.getenv("ProgramFiles");
                                    if (!((String)object2).endsWith("\\")) {
                                        object2 = (String)object2 + "\\";
                                    }
                                    String string2 = System.getenv("USERPROFILE") + "\\AppData\\Local\\VirtualStore\\Program Files\\";
                                    if (string.indexOf((String)object2) != -1) {
                                        object = new File(string = string.replaceFirst((String)object2, string2));
                                        if (!((File)object).exists()) {
                                            System.err.println("Error while creating VLT: File not found, not even in VirtualStore! " + string);
                                        }
                                    } else {
                                        System.err.println("Error while creating VLT: File not found! " + string);
                                    }
                                } else {
                                    System.err.println("Error while creating VLT: File not found! " + string);
                                }
                            }
                            tarGzOutputStream.putNextEntry(new TarEntry(resource.file));
                            object2 = new FileInputStream((File)object);
                            while ((n3 = ((FileInputStream)object2).read()) != -1) {
                                tarGzOutputStream.write(n3);
                            }
                            ((FileInputStream)object2).close();
                            tarGzOutputStream.closeEntry();
                            linkedList.add(string);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            progressWindow.setVisible(false);
                            JOptionPane.showMessageDialog(this, Language.get("ERROR_VLT_MSG"), Language.get("ERROR_VLT_TILE"), 0);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!this.s.resources.get(i).getClass().equals(Font.class)) continue;
                    try {
                        int n4;
                        resource = (Font)this.s.resources.get(i);
                        string = this.s.skinfolder + ((Font)resource).file;
                        if (linkedList.contains(string)) continue;
                        tarGzOutputStream.putNextEntry(new TarEntry(((Font)resource).file));
                        object = new FileInputStream(string);
                        while ((n4 = ((FileInputStream)object).read()) != -1) {
                            tarGzOutputStream.write(n4);
                        }
                        ((FileInputStream)object).close();
                        tarGzOutputStream.closeEntry();
                        linkedList.add(string);
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        progressWindow.setVisible(false);
                        JOptionPane.showMessageDialog(this, Language.get("ERROR_VLT_MSG"), Language.get("ERROR_VLT_TILE"), 0);
                    }
                }
                tarGzOutputStream.close();
                progressWindow.setVisible(false);
                JOptionPane.showMessageDialog(this, Language.get("VLT_SUCCESS_MSG"), Language.get("VLT_SUCCESS_TITLE"), 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                progressWindow.setVisible(false);
                JOptionPane.showMessageDialog(this, Language.get("ERROR_VLT_MSG"), Language.get("ERROR_VLT_TILE"), 0);
                return;
            }
        } else if (actionEvent.getSource().equals(this.m_file_png)) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new CustomFileFilter(jFileChooser, "png", "*.PNG (Portable Network Graphics)", false, ""));
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!file.getPath().toLowerCase().endsWith(".png")) {
                    file = new File(file.getPath() + ".png");
                }
                this.pvwin.savePNG(file);
            }
        } else if (actionEvent.getSource().equals(this.m_file_quit)) {
            this.exit();
        } else if (actionEvent.getSource().equals(this.m_edit_theme)) {
            this.s.showThemeOptions();
        } else if (actionEvent.getSource().equals(this.m_edit_vars)) {
            this.s.gvars.showOptions();
        } else if (actionEvent.getSource().equals(this.m_edit_prefs)) {
            Config.showOptions();
        } else if (actionEvent.getSource().equals(this.m_help_doc)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/");
        } else if (actionEvent.getSource().equals(this.m_help_about)) {
            JOptionPane.showMessageDialog(this, Language.get("ABOUT_MSG").replaceAll("%w", "http://www.videolan.org/vlc/skineditor.html").replaceAll("%y", String.valueOf(Calendar.getInstance().get(1)).replaceAll("%v", VERSION)), Language.get("ABOUT_TITLE").replaceAll("%v", VERSION), 1, icon);
        } else if (actionEvent.getSource().equals(this.res_add_bitmap)) {
            this.res_add_bitmap_pu.show(this.res_add_bitmap, 0, 0);
        } else if (actionEvent.getSource().equals(this.res_add_bitmap_pu_b)) {
            int n;
            if (this.bitmap_adder == null) {
                this.bitmap_adder = new JFileChooser();
                this.bitmap_adder.setFileFilter(new CustomFileFilter(this.bitmap_adder, "png", Language.get("ADD_BMP_FILE_FILTER_DESC"), true, this.s.skinfolder));
                this.bitmap_adder.setCurrentDirectory(new File(this.s.skinfolder));
                this.bitmap_adder.setAcceptAllFileFilterUsed(false);
                this.bitmap_adder.setMultiSelectionEnabled(true);
            }
            if ((n = this.bitmap_adder.showOpenDialog(this)) == 0) {
                File[] fileArray = this.bitmap_adder.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.s.resources.add(new Bitmap(this.s, fileArray[i]));
                }
                this.s.updateResources();
            }
        } else if (actionEvent.getSource().equals(this.res_add_bitmap_pu_s)) {
            if (this.selected_resource != null) {
                Resource resource = this.s.getResource(this.selected_resource);
                if (resource != null) {
                    if (resource.getClass() == Bitmap.class) {
                        Bitmap bitmap = (Bitmap)resource;
                        bitmap.SubBitmaps.add(new SubBitmap(this.s, bitmap));
                    } else if (resource.getClass() == SubBitmap.class) {
                        SubBitmap subBitmap = (SubBitmap)resource;
                        Bitmap bitmap = subBitmap.getParentBitmap();
                        bitmap.SubBitmaps.add(new SubBitmap(this.s, bitmap));
                    } else {
                        JOptionPane.showMessageDialog(this, Language.get("ERROR_ADD_SBMP_NOTBMP"), Language.get("ERROR_ADD_SBMP_TITLE"), 1);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, Language.get("ERROR_ADD_SBMP_NOBMP"), Language.get("ERROR_ADD_SBMP_TITLE"), 1);
                }
            } else {
                JOptionPane.showMessageDialog(this, Language.get("ERROR_ADD_SBMP_NOBMP"), Language.get("ERROR_ADD_SBMP_TITLE"), 1);
            }
        } else if (actionEvent.getSource().equals(this.res_add_font)) {
            int n;
            if (this.font_adder == null) {
                this.font_adder = new JFileChooser();
                String[] stringArray = new String[]{"ttf", "otf"};
                this.font_adder.setFileFilter(new CustomFileFilter(this.font_adder, stringArray, Language.get("ADD_FONT_FILE_FILTER_DESC"), true, this.s.skinfolder));
                this.font_adder.setCurrentDirectory(new File(this.s.skinfolder));
                this.font_adder.setAcceptAllFileFilterUsed(false);
                this.font_adder.setMultiSelectionEnabled(true);
            }
            if ((n = this.font_adder.showOpenDialog(this)) == 0) {
                File[] fileArray = this.font_adder.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.s.resources.add(new Font(this.s, fileArray[i]));
                }
                this.s.updateResources();
            }
        } else if (actionEvent.getSource().equals(this.res_duplicate)) {
            if (this.selected_resource == null) {
                return;
            }
            Resource resource = this.s.getResource(this.selected_resource);
            if (resource == null) {
                return;
            }
            String string = JOptionPane.showInputDialog(this, Language.get("DUPLICATE_MSG"), "%oldid%_copy");
            if (resource.getClass() == Bitmap.class) {
                Bitmap bitmap = (Bitmap)resource;
                Bitmap bitmap2 = new Bitmap(bitmap.returnCode(""), this.s);
                bitmap2.renameForCopy(string);
                this.s.resources.add(bitmap2);
                this.s.updateResources();
                this.s.expandResource(bitmap.id);
            } else if (resource.getClass() == SubBitmap.class) {
                SubBitmap subBitmap = (SubBitmap)resource;
                SubBitmap subBitmap2 = new SubBitmap(subBitmap.returnCode(""), this.s, subBitmap.getParentBitmap());
                subBitmap2.renameForCopy(string);
                subBitmap.getParentBitmap().SubBitmaps.add(subBitmap2);
                this.s.updateResources();
                this.s.expandResource(subBitmap.id);
            } else {
                Font font = (Font)resource;
                Font font2 = new Font(font.returnCode(""), this.s);
                font2.renameForCopy(string);
                this.s.resources.add(font2);
                this.s.updateResources();
                this.s.expandResource(font.id);
            }
        } else if (actionEvent.getSource().equals(this.win_duplicate)) {
            if (this.selected_window == null) {
                return;
            }
            String string = JOptionPane.showInputDialog(this, Language.get("DUPLICATE_MSG"), "%oldid%_copy");
            if (this.selected_layout == null) {
                Window window = this.s.getWindow(this.selected_window);
                if (window == null) {
                    return;
                }
                Window window2 = new Window(window.returnCode(""), this.s);
                window2.renameForCopy(string);
                this.s.windows.add(window2);
                this.s.updateWindows();
            } else {
                Window window = this.s.getWindow(this.selected_window);
                Layout layout = window.getLayout(this.selected_layout);
                Layout layout2 = new Layout(layout.returnCode(""), window, this.s);
                layout2.renameForCopy(string);
                window.layouts.add(layout2);
                this.s.updateWindows();
                this.s.expandLayout(layout2.id);
            }
        } else if (actionEvent.getSource().equals(this.items_duplicate)) {
            if (this.selected_item == null) {
                return;
            }
            String string = JOptionPane.showInputDialog(this, Language.get("DUPLICATE_MSG"), "%oldid%_copy");
            Item item = this.s.getItem(this.selected_item);
            if (item == null) {
                return;
            }
            if (item.getClass() == Anchor.class) {
                Anchor anchor = new Anchor(item.returnCode(""), this.s);
                anchor.id = item.id;
                anchor.renameForCopy(string);
                this.s.getParentListOf(item.id).add(anchor);
                this.s.updateItems();
                this.s.expandItem(anchor.id);
            } else if (item.getClass() == Button.class) {
                Button button = new Button(item.returnCode(""), this.s);
                button.renameForCopy(string);
                this.s.getParentListOf(item.id).add(button);
                this.s.updateItems();
                this.s.expandItem(button.id);
            } else if (item.getClass() == Checkbox.class) {
                Checkbox checkbox = new Checkbox(item.returnCode(""), this.s);
                checkbox.renameForCopy(string);
                this.s.getParentListOf(item.id).add(checkbox);
                this.s.updateItems();
                this.s.expandItem(checkbox.id);
            } else if (item.getClass() == Group.class) {
                Group group = new Group(item.returnCode(""), this.s);
                group.renameForCopy(string);
                this.s.getParentListOf(item.id).add(group);
                this.s.updateItems();
                this.s.expandItem(group.id);
            } else if (item.getClass() == Image.class) {
                Image image = new Image(item.returnCode(""), this.s);
                image.renameForCopy(string);
                this.s.getParentListOf(item.id).add(image);
                this.s.updateItems();
                this.s.expandItem(image.id);
            } else if (item.getClass() == Panel.class) {
                Panel panel = new Panel(item.returnCode(""), this.s);
                panel.renameForCopy(string);
                this.s.getParentListOf(item.id).add(panel);
                this.s.updateItems();
                this.s.expandItem(panel.id);
            } else if (item.getClass() == Playtree.class) {
                Playtree playtree = new Playtree(item.returnCode(""), this.s);
                playtree.renameForCopy(string);
                this.s.getParentListOf(item.id).add(playtree);
                this.s.updateItems();
                this.s.expandItem(playtree.id);
            } else if (item.getClass() == RadialSlider.class) {
                RadialSlider radialSlider = new RadialSlider(item.returnCode(""), this.s);
                radialSlider.renameForCopy(string);
                this.s.getParentListOf(item.id).add(radialSlider);
                this.s.updateItems();
                this.s.expandItem(radialSlider.id);
            } else if (item.getClass() == Slider.class) {
                Slider slider = new Slider(item.returnCode(""), this.s);
                slider.renameForCopy(string);
                List<Item> list = this.s.getParentListOf(item.id);
                if (list != null) {
                    list.add(slider);
                    this.s.updateItems();
                    this.s.expandItem(slider.id);
                } else {
                    JOptionPane.showMessageDialog(this, "A PlayTree cannot contain more than one slider!", "Slider could not be duplicated", 1);
                }
            } else if (item.getClass() == SliderBackground.class) {
                JOptionPane.showMessageDialog(this, "A slider cannot contain more than one background!", "SliderBackgrounds cannot be duplicated", 1);
            } else if (item.getClass() == Text.class) {
                Text text = new Text(item.returnCode(""), this.s);
                text.renameForCopy(string);
                this.s.getParentListOf(item.id).add(text);
                this.s.updateItems();
                this.s.expandItem(text.id);
            } else if (item.getClass() == Video.class) {
                Video video = new Video(item.returnCode(""), this.s);
                video.renameForCopy(string);
                this.s.getParentListOf(item.id).add(video);
                this.s.updateItems();
                this.s.expandItem(video.id);
            }
        } else if (actionEvent.getSource().equals(this.res_edit)) {
            Resource resource;
            if (this.selected_resource != null && (resource = this.s.getResource(this.selected_resource)) != null) {
                resource.showOptions();
            }
        } else if (actionEvent.getSource().equals(this.res_del)) {
            if (this.s.isUsed(this.selected_resource)) {
                JOptionPane.showMessageDialog(this, Language.get("ERROR_RES_DEL_INUSE"), Language.get("ERROR_RES_DEL_TITLE"), 1);
            } else {
                Object[] objectArray = new Object[]{Language.get("CHOICE_YES"), Language.get("CHOICE_NO")};
                int n = JOptionPane.showOptionDialog(this, Language.get("DEL_CONFIRM_MSG").replaceAll("%n", this.selected_resource), Language.get("DEL_CONFIRM_TITLE"), 0, 3, null, objectArray, objectArray[1]);
                if (n == 0) {
                    Resource resource = this.s.getResource(this.selected_resource);
                    Bitmap bitmap = null;
                    if (resource.getClass().equals(SubBitmap.class)) {
                        for (Resource resource2 : this.s.resources) {
                            if (!resource2.getClass().equals(Bitmap.class) || !((Bitmap)resource2).SubBitmaps.contains(resource)) continue;
                            bitmap = (Bitmap)resource2;
                        }
                        SubBitmapDeletionEvent subBitmapDeletionEvent = new SubBitmapDeletionEvent(this.s, bitmap, (SubBitmap)resource, bitmap.SubBitmaps.indexOf(resource));
                        this.hist.addEvent(subBitmapDeletionEvent);
                        bitmap.SubBitmaps.remove(resource);
                    } else {
                        ResourceDeletionEvent resourceDeletionEvent = new ResourceDeletionEvent(this.s, resource, this.s.resources.indexOf(resource));
                        this.hist.addEvent(resourceDeletionEvent);
                        this.s.resources.remove(resource);
                    }
                    this.s.updateResources();
                }
            }
        } else if (actionEvent.getSource().equals(this.win_add_window)) {
            this.s.windows.add(new Window(this.s));
        } else if (actionEvent.getSource().equals(this.win_add_layout)) {
            if (this.selected_window != null) {
                Window window = this.s.getWindow(this.selected_window);
                if (window != null) {
                    window.addLayout();
                }
            } else {
                JOptionPane.showMessageDialog(this, Language.get("ERROR_ADD_LAYOUT_MSG"), Language.get("ERROR_ADD_LAYOUT_TITLE"), 1);
            }
        } else if (actionEvent.getSource().equals(this.win_layout_up)) {
            Window window = this.s.getWindow(this.selected_window);
            Layout layout = window.getLayout(this.selected_layout);
            if (layout == null) {
                return;
            }
            int n = window.layouts.indexOf(layout);
            if (n <= 0) {
                return;
            }
            window.layouts.set(n, window.layouts.set(n - 1, layout));
            this.s.updateWindows();
            this.s.expandLayout(layout.id);
        } else if (actionEvent.getSource().equals(this.win_layout_down)) {
            Window window = this.s.getWindow(this.selected_window);
            Layout layout = window.getLayout(this.selected_layout);
            if (layout == null) {
                return;
            }
            int n = window.layouts.indexOf(layout);
            if (n >= window.layouts.size() - 1) {
                return;
            }
            window.layouts.set(n, window.layouts.set(n + 1, layout));
            this.s.updateWindows();
            this.s.expandLayout(layout.id);
        } else if (actionEvent.getSource().equals(this.win_edit)) {
            Window window;
            if (this.selected_layout != null && this.selected_window != null) {
                Layout layout = this.s.getWindow(this.selected_window).getLayout(this.selected_layout);
                if (layout != null) {
                    layout.showOptions();
                }
            } else if (this.selected_window != null && (window = this.s.getWindow(this.selected_window)) != null) {
                window.showOptions();
            }
        } else if (actionEvent.getSource().equals(this.win_del)) {
            Window window;
            if (this.selected_layout != null) {
                Window window3 = this.s.getWindow(this.selected_window);
                Layout layout = window3.getLayout(this.selected_layout);
                if (layout != null) {
                    Object[] objectArray = new Object[]{Language.get("CHOICE_YES"), Language.get("CHOICE_NO")};
                    int n = JOptionPane.showOptionDialog(this, Language.get("DEL_CONFIRM_MSG").replaceAll("%n", layout.id), Language.get("DEL_CONFIRM_TITLE"), 0, 3, null, objectArray, objectArray[1]);
                    if (n == 0) {
                        LayoutDeletionEvent layoutDeletionEvent = new LayoutDeletionEvent(window3, layout, window3.layouts.indexOf(layout), this.s);
                        this.pvwin.clearLayout();
                        this.m_file_png.setEnabled(false);
                        window3.layouts.remove(layout);
                        this.s.updateWindows();
                        this.s.updateItems();
                        this.hist.addEvent(layoutDeletionEvent);
                    }
                }
            } else if (this.selected_window != null && (window = this.s.getWindow(this.selected_window)) != null) {
                Object[] objectArray = new Object[]{Language.get("CHOICE_YES"), Language.get("CHOICE_NO")};
                int n = JOptionPane.showOptionDialog(this, Language.get("DEL_CONFIRM_MSG").replaceAll("%n", window.id), Language.get("DEL_CONFIRM_TITLE"), 0, 3, null, objectArray, objectArray[1]);
                if (n == 0) {
                    WindowDeletionEvent windowDeletionEvent = new WindowDeletionEvent(window, this.s, this.s.windows.indexOf(window));
                    this.s.windows.remove(window);
                    this.s.updateWindows();
                    this.hist.addEvent(windowDeletionEvent);
                }
            }
        } else if (actionEvent.getSource().equals(this.items_add)) {
            Item item;
            if (this.selected_layout == null) {
                return;
            }
            this.items_add_pu_tp.setEnabled(false);
            if (this.selected_item != null && (item = this.s.getItem(this.selected_item)) != null) {
                if (item.getClass().equals(Group.class)) {
                    this.items_add_pu_tp.setEnabled(true);
                }
                if (item.getClass().equals(Panel.class)) {
                    this.items_add_pu_tp.setEnabled(true);
                }
            }
            this.items_add_pu.setSelected(null);
            this.items_add_pu.show(this.items_add, 0, 0);
        } else if (actionEvent.getSource().equals(this.items_up)) {
            Item item = this.s.getItem(this.selected_item);
            if (item == null) {
                return;
            }
            List<Item> list = this.s.getParentListOf(this.selected_item);
            if (list == null) {
                return;
            }
            int n = list.indexOf(item);
            if (n <= 0) {
                return;
            }
            list.set(n, list.set(n - 1, item));
            this.s.updateItems();
            this.s.expandItem(this.selected_item);
        } else if (actionEvent.getSource().equals(this.items_down)) {
            Item item = this.s.getItem(this.selected_item);
            if (item == null) {
                return;
            }
            List<Item> list = this.s.getParentListOf(this.selected_item);
            int n = list.indexOf(item);
            if (n >= list.size() - 1) {
                return;
            }
            list.set(n, list.set(n + 1, item));
            this.s.updateItems();
            this.s.expandItem(this.selected_item);
        } else if (actionEvent.getSource().equals(this.items_edit)) {
            Item item;
            if (this.selected_item != null && (item = this.s.getItem(this.selected_item)) != null) {
                item.showOptions();
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_anchor)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Anchor(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_button)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Button(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_checkbox)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Checkbox(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_panel)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Panel(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_image)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Image(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_playtree)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Playtree(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_slider)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Slider(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_text)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Text(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_video)) {
            List<Item> list = null;
            if (this.selected_item != null) {
                list = this.s.getParentListOf(this.selected_item);
            }
            if (list == null) {
                list = this.s.getWindow((String)this.selected_window).getLayout((String)this.selected_layout).items;
            }
            list.add(new Video(this.s));
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_anchor)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Anchor(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_button)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Button(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_checkbox)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Checkbox(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_image)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Image(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_panel)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Panel(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_playtree)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Playtree(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_slider)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Slider(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_text)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Text(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_add_pu_tp_video)) {
            List<Item> list = this.s.getListOf(this.selected_item);
            if (list != null) {
                list.add(new Video(this.s));
            }
        } else if (actionEvent.getSource().equals(this.items_del)) {
            List<Item> list;
            if (this.selected_item != null && (list = this.s.getParentListOf(this.selected_item)) != null) {
                Object[] objectArray = new Object[]{Language.get("CHOICE_YES"), Language.get("CHOICE_NO")};
                int n = JOptionPane.showOptionDialog(this, Language.get("DEL_CONFIRM_MSG").replaceAll("%n", this.selected_item), Language.get("DEL_CONFIRM_TITLE"), 0, 3, null, objectArray, objectArray[1]);
                if (n == 0) {
                    Item item = this.s.getItem(this.selected_item);
                    ItemDeletionEvent itemDeletionEvent = new ItemDeletionEvent(list, item, list.indexOf(item), this.s);
                    list.remove(this.s.getItem(this.selected_item));
                    this.s.updateItems();
                    this.hist.addEvent(itemDeletionEvent);
                }
            }
        } else if (actionEvent.getSource().equals(this.m_edit_up)) {
            this.pvwin.moveItem(0, -1);
        } else if (actionEvent.getSource().equals(this.m_edit_down)) {
            this.pvwin.moveItem(0, 1);
        } else if (actionEvent.getSource().equals(this.m_edit_right)) {
            this.pvwin.moveItem(1, 0);
        } else if (actionEvent.getSource().equals(this.m_edit_left)) {
            this.pvwin.moveItem(-1, 0);
        } else if (actionEvent.getSource().equals(this.m_edit_undo)) {
            if (this.hist != null) {
                this.hist.undo();
            }
        } else if (actionEvent.getSource().equals(this.m_edit_redo) && this.hist != null) {
            this.hist.redo();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.opening) {
            return;
        }
        if (treeSelectionEvent.getSource().equals(this.res_tree)) {
            String string = treeSelectionEvent.getPath().getLastPathComponent().toString();
            this.selected_resource = string.substring(string.indexOf(": ") + 2);
        } else if (treeSelectionEvent.getSource().equals(this.win_tree)) {
            this.selected_in_windows = treeSelectionEvent.getPath().getLastPathComponent().toString();
            Object[] objectArray = treeSelectionEvent.getPath().getPath();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].toString().substring(0, objectArray[i].toString().indexOf(": "));
                if (string.equals("Window")) {
                    this.selected_window = objectArray[i].toString().substring(objectArray[i].toString().indexOf(": ") + 2);
                    this.selected_layout = null;
                    this.pvwin.clearLayout();
                    this.items_tree_model.setRoot(new DefaultMutableTreeNode("Root: Items"));
                    this.m_file_png.setEnabled(false);
                    this.win_layout_up.setEnabled(false);
                    this.win_layout_down.setEnabled(false);
                    continue;
                }
                if (!string.equals("Layout")) continue;
                this.selected_layout = objectArray[i].toString().substring(objectArray[i].toString().indexOf(": ") + 2);
                this.pvwin.setLayout(this.s.getWindow(this.selected_window), this.s.getWindow(this.selected_window).getLayout(this.selected_layout));
                this.s.updateItems();
                this.m_file_png.setEnabled(true);
                this.win_layout_up.setEnabled(true);
                this.win_layout_down.setEnabled(true);
            }
        } else if (treeSelectionEvent.getSource().equals(this.items_tree)) {
            String string = treeSelectionEvent.getPath().getLastPathComponent().toString();
            this.selected_item = string.substring(string.indexOf(": ") + 2);
            this.pvwin.selectItem(this.s.getItem(this.selected_item));
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.exit();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (this.pvwin == null) {
            return;
        }
        if (this.pvwin.fu == null) {
            this.pvwin.fu = new FrameUpdater(this.pvwin, 5);
            this.pvwin.fu.start();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        if (this.pvwin == null || this.pvwin.fu == null) {
            return;
        }
        this.pvwin.fu.stopRunning();
        this.pvwin.fu = null;
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.pvwin.fu == null) {
            this.pvwin.fu = new FrameUpdater(this.pvwin, 5);
            this.pvwin.fu.start();
        }
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        if (this.pvwin == null || this.pvwin.fu == null) {
            return;
        }
        this.pvwin.fu.stopRunning();
        this.pvwin.fu = null;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            if (mouseEvent.getSource().equals(this.res_tree)) {
                this.actionPerformed(new ActionEvent(this.res_edit, 1001, "Doubleclick"));
            } else if (mouseEvent.getSource().equals(this.win_tree)) {
                this.actionPerformed(new ActionEvent(this.win_edit, 1001, "Doubleclick"));
            } else if (mouseEvent.getSource().equals(this.items_tree)) {
                this.actionPerformed(new ActionEvent(this.items_edit, 1001, "Doubleclick"));
            }
        } else if (mouseEvent.getSource().equals(this.res_tree)) {
            TreePath treePath = this.res_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (this.res_tree.isExpanded(treePath)) {
                this.res_tree.collapsePath(treePath);
            } else {
                this.res_tree.expandPath(treePath);
            }
        } else if (mouseEvent.getSource().equals(this.win_tree)) {
            TreePath treePath = this.win_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (this.win_tree.isExpanded(treePath)) {
                this.win_tree.collapsePath(treePath);
            } else {
                this.win_tree.expandPath(treePath);
            }
        } else if (mouseEvent.getSource().equals(this.items_tree)) {
            TreePath treePath = this.items_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            if (this.items_tree.isExpanded(treePath)) {
                this.items_tree.collapsePath(treePath);
            } else {
                this.items_tree.expandPath(treePath);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setUndoEnabled(boolean bl) {
        this.m_edit_undo.setEnabled(bl);
    }

    public void setRedoEnabled(boolean bl) {
        this.m_edit_redo.setEnabled(bl);
    }

    public void setUndoString(String string) {
        if (string.isEmpty()) {
            this.m_edit_undo.setText(Language.get("MENU_EDIT_UNDO"));
        } else {
            this.m_edit_undo.setText(Language.get("MENU_EDIT_UNDO") + ": " + string);
        }
    }

    public void setRedoString(String string) {
        if (string.isEmpty()) {
            this.m_edit_redo.setText(Language.get("MENU_EDIT_REDO"));
        } else {
            this.m_edit_redo.setText(Language.get("MENU_EDIT_REDO") + ": " + string);
        }
    }

    public static ImageIcon createIcon(String string) {
        java.awt.Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().createImage(Main.class.getResource(string));
            return new ImageIcon(image);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    private void update() {
        if (VERSION.contains("dev")) {
            return;
        }
        try {
            URL uRL = new URL("http://www.videolan.org/vlc/skineditor_update.php?v=" + URLEncoder.encode(VERSION, "UTF-8") + "&os=" + URLEncoder.encode(System.getProperty("os.name"), "UTF-8"));
            InputStream inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            if (string.equals("SKINEDITORUPDATEPAGE")) {
                String string2 = bufferedReader.readLine();
                String string3 = bufferedReader.readLine();
                if (!string2.equals(VERSION)) {
                    System.out.println("Update available!");
                    int n = JOptionPane.showConfirmDialog(this, Language.get("UPDATE_MSG").replaceAll("%v", VERSION).replaceAll("%c", string2), Language.get("UPDATE_TITLE"), 0);
                    if (n == 0) {
                        byte[] byArray;
                        int n2;
                        URL uRL2 = new URL(string3);
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
                        httpURLConnection.connect();
                        if (httpURLConnection.getResponseCode() / 100 != 2) {
                            throw new Exception("Server error! Response code: " + httpURLConnection.getResponseCode());
                        }
                        int n3 = httpURLConnection.getContentLength();
                        if (n3 < 1) {
                            throw new Exception("Invalid content length!");
                        }
                        int n4 = n3;
                        File file = File.createTempFile("vlcse_update", ".zip");
                        file.deleteOnExit();
                        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                        InputStream inputStream2 = httpURLConnection.getInputStream();
                        int n5 = 0;
                        ProgressWindow progressWindow = new ProgressWindow(this, Language.get("DOWNLOAD_PROGRESS"));
                        progressWindow.setVisible(true);
                        progressWindow.setProgress(0.0);
                        progressWindow.setText(Language.get("CONNECT_PROGRESS"));
                        while (n5 < n4 && (n2 = inputStream2.read(byArray = n4 - n5 > 1024 ? new byte[1024] : new byte[n4 - n5])) != -1) {
                            randomAccessFile.write(byArray, 0, n2);
                            progressWindow.setProgress((n5 += n2) / n4);
                        }
                        randomAccessFile.close();
                        System.out.println("Downloaded file to " + file.getAbsolutePath());
                        progressWindow.setVisible(false);
                        progressWindow.dispose();
                        progressWindow = null;
                        Helper.unzip(file);
                        JOptionPane.showMessageDialog(this, Language.get("UPDATE_SUCCESS_MSG"), Language.get("UPDATE_SUCCESS_TITLE"), 1);
                        this.setVisible(false);
                        if (System.getProperty("os.name").indexOf("Windows") != -1) {
                            Runtime.getRuntime().exec("VLCSkinEditor.exe");
                        } else {
                            Runtime.getRuntime().exec("java -jar VLCSkinEditor.jar");
                        }
                        System.exit(0);
                    }
                }
            } else {
                bufferedReader.close();
                inputStreamReader.close();
                inputStream.close();
                throw new Exception("Update page had invalid header: " + string);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), Language.get("ERROR_UPDATE_TITLE"), 0);
            exception.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exit() {
        if (!this.saved) {
            Object[] objectArray = new Object[]{Language.get("CHOICE_YES"), Language.get("CHOICE_NO"), Language.get("CHOICE_CANCEL")};
            int n = JOptionPane.showOptionDialog(this, Language.get("EXIT_CONFIRM_MSG"), Language.get("EXIT_CONFIRM_TITLE"), 1, 3, null, objectArray, objectArray[1]);
            if (n == 0) {
                this.s.save();
                this.doExit();
                return;
            } else {
                if (n != 1) return;
                this.doExit();
            }
            return;
        } else {
            this.doExit();
        }
    }

    private void doExit() {
        if (this.getExtendedState() != 6) {
            Config.set("win.main.x", this.getX());
            Config.set("win.main.y", this.getY());
            Config.set("win.main.width", this.getWidth());
            Config.set("win.main.height", this.getHeight());
            Config.set("win.main.maximized", "false");
        } else {
            Config.set("win.main.maximized", "true");
        }
        Config.set("win.res.x", this.resources.getX());
        Config.set("win.res.y", this.resources.getY());
        Config.set("win.res.width", this.resources.getWidth());
        Config.set("win.res.height", this.resources.getHeight());
        Config.set("win.win.x", this.windows.getX());
        Config.set("win.win.y", this.windows.getY());
        Config.set("win.win.width", this.windows.getWidth());
        Config.set("win.win.height", this.windows.getHeight());
        Config.set("win.items.x", this.items.getX());
        Config.set("win.items.y", this.items.getY());
        Config.set("win.items.width", this.items.getWidth());
        Config.set("win.items.height", this.items.getHeight());
        if (this.base_fc != null) {
            Config.set("open.folder", this.base_fc.getCurrentDirectory().getAbsolutePath());
        }
        Config.save();
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        if (new File("VLCSkinEditor.old.exe").exists()) {
            new File("VLCSkinEditor.old.exe").delete();
            new File("lang.zip").delete();
        }
        if (new File(".updated").exists()) {
            System.out.println("Performing post-update steps to 0.8.1");
            if (System.getProperty("os.name").indexOf("Windows") == -1) {
                new File("VLCSkinEditor.new.exe").delete();
                new File("ICE_JNIRegistry.dll").delete();
            } else {
                new File("VLCSkinEditor.exe").renameTo(new File("VLCSkinEditor.old.exe"));
                new File("VLCSkinEditor.new.exe").renameTo(new File("VLCSkinEditor.exe"));
                try {
                    object2 = Registry.openSubkey(Registry.HKEY_CLASSES_ROOT, "VLCSkinFile\\DefaultIcon", 4);
                    if (((RegistryKey)object2).hasDefaultValue()) {
                        object = ((RegistryKey)object2).getValue("");
                        String string = new String(((RegistryValue)object).getByteData()) + ",2";
                        ((RegistryValue)object).setByteData(string.getBytes());
                        ((RegistryKey)object2).setValue((RegistryValue)object);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Could not change VLT icon");
                    exception.printStackTrace();
                }
            }
            object2 = new File("lang.zip");
            if (((File)object2).exists()) {
                try {
                    Helper.unzip((File)object2);
                    ((File)object2).delete();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            new File(".updated").delete();
        }
        Config.load();
        Language.loadLanguageByCode(Config.get("language"));
        try {
            object = object2 = Config.get("swing.laf");
            if (object2 != null) {
                if (((String)object2).equals("System")) {
                    object = UIManager.getSystemLookAndFeelClassName();
                }
                if (((String)object2).equals("Metal: Steel")) {
                    object = UIManager.getCrossPlatformLookAndFeelClassName();
                    MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                } else if (((String)object2).equals("Metal: Ocean")) {
                    object = UIManager.getCrossPlatformLookAndFeelClassName();
                    MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                }
            }
            UIManager.setLookAndFeel((String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "VLC Skin Editor");
        new Main(stringArray);
    }
}

