/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import vlcskineditor.Item;
import vlcskineditor.Skin;
import vlcskineditor.items.Panel;
import vlcskineditor.items.Slider;
import vlcskineditor.items.SliderBackground;

public class ItemTransferHandler
extends TransferHandler {
    private Skin s;
    private DataFlavor itemFlavor = new DataFlavor(Item.class, "Skin item");

    public ItemTransferHandler(Skin skin) {
        this.s = skin;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 2;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (transferSupport.isDataFlavorSupported(this.itemFlavor)) {
            try {
                Item item = (Item)transferSupport.getTransferable().getTransferData(this.itemFlavor);
                TransferHandler.DropLocation dropLocation = transferSupport.getDropLocation();
                TreePath treePath = ((JTree)transferSupport.getComponent()).getPathForLocation(dropLocation.getDropPoint().x, dropLocation.getDropPoint().y);
                String string = treePath.getLastPathComponent().toString();
                string = string.substring(string.indexOf(": ") + 2);
                if (item.id.equals(string)) {
                    return false;
                }
                if (item.getClass().equals(Slider.class)) {
                    return !((Slider)item).isInPlaytree();
                }
                return !item.getClass().equals(SliderBackground.class);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        String string = jTree.getSelectionPath().getLastPathComponent().toString();
        String string2 = string.substring(string.indexOf(": ") + 2);
        Item item = this.s.getItem(string2);
        return new ItemTransferer(item);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDrop()) {
            return false;
        }
        JTree jTree = (JTree)transferSupport.getComponent();
        TransferHandler.DropLocation dropLocation = transferSupport.getDropLocation();
        TreePath treePath = jTree.getPathForLocation(dropLocation.getDropPoint().x, dropLocation.getDropPoint().y);
        if (treePath.getPathCount() == 1) {
            return false;
        }
        String string = treePath.getLastPathComponent().toString();
        string = string.substring(string.indexOf(": ") + 2);
        Item item = this.s.getItem(string);
        Item item2 = null;
        try {
            item2 = (Item)transferSupport.getTransferable().getTransferData(this.itemFlavor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        List<Item> list = this.s.getParentListOf(item2.id);
        list.remove(item2);
        if (item.getClass().equals(Panel.class)) {
            ((Panel)item).items.add(item2);
        } else {
            List<Item> list2 = this.s.getParentListOf(string);
            list2.add(list2.indexOf(item), item2);
        }
        (new Thread(item2.id){
            private String id;

            private Thread setID(String string) {
                this.id = string;
                return this;
            }

            @Override
            public void run() {
                try {
                    1.sleep(10L);
                    ItemTransferHandler.this.s.updateItems();
                    ItemTransferHandler.this.s.expandItem(this.id);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }).setID(item2.id).start();
        return true;
    }

    private class ItemTransferer
    implements Transferable {
        private Item i;

        public ItemTransferer(Item item) {
            this.i = item;
        }

        public Item getItem() {
            return this.i;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{ItemTransferHandler.this.itemFlavor};
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == ItemTransferHandler.this.itemFlavor;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(dataFlavor)) {
                return this.i;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

